% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsdensity_functions.R
\name{compute.spec}
\alias{compute.spec}
\title{This is to calculate the similarity between:
1. the label propagation probability of cells for gene sets and
2. the identify of cells in partitions}
\usage{
\method{compute}{spec}(cell_df, metadata, cell_group)
}
\arguments{
\item{cell_df}{the output of run.rwr.list}

\item{metadata}{a data frame with cell information (each row is a cell;
usually object@meta.data)}

\item{cell_group}{cell partition vector (usually a column name}
}
\value{
specificity of a pathway activity and other levels of cell annotations (e.g., cell type)
in object@meta.data)
}
\description{
This is to calculate the similarity between:
1. the label propagation probability of cells for gene sets and
2. the identify of cells in partitions
}
\examples{
\donttest{
cells <- colnames(pbmc.mtx)
el <- gsdensity::compute.nn.edges(coembed = ce, nn.use = 300)
cv <- gsdensity::run.rwr.list(el = el, gene_set = gene.set.list[1:30], cells = cells)
jsd.df <- compute.spec(cell_df = cv,
                      metadata = pbmc.meta,
                      cell_group = "seurat_annotations"
                     )
}
}
