% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/attributes.R
\name{vertex_attr}
\alias{get.vertex.attribute}
\alias{vertex.attributes}
\alias{vertex_attr}
\title{Query vertex attributes of a graph}
\usage{
vertex_attr(graph, name, index = V(graph))
}
\arguments{
\item{graph}{The graph.}

\item{name}{Name of the attribute to query. If missing, then
all vertex attributes are returned in a list.}

\item{index}{A vertex sequence, to query the attribute only
for these vertices.}
}
\value{
The value of the vertex attribute, or the list of
  all vertex attributes, if \code{name} is missing.
}
\description{
Query vertex attributes of a graph
}
\examples{
g <- make_ring(10) \%>\%
  set_vertex_attr("color", value = "red") \%>\%
  set_vertex_attr("label", value = letters[1:10])
vertex_attr(g, "label")
vertex_attr(g)
plot(g)
}
\seealso{
Other graph attributes: \code{\link{$.igraph.vs}},
  \code{\link{$<-.igraph.vs}}, \code{\link{V<-}},
  \code{\link{[<-.igraph.vs}},
  \code{\link{[[<-.igraph.vs}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}};
  \code{\link{$.igraph}}, \code{\link{$<-.igraph}},
  \code{\link{igraph-dollar}}, \code{\link{igraph-dollar}};
  \code{\link{attributes}}, \code{\link{graph_attr_names}},
  \code{\link{list.graph.attributes}};
  \code{\link{delete_edge_attr}},
  \code{\link{remove.edge.attribute}};
  \code{\link{delete_graph_attr}},
  \code{\link{remove.graph.attribute}};
  \code{\link{delete_vertex_attr}},
  \code{\link{remove.vertex.attribute}};
  \code{\link{edge.attributes<-}},
  \code{\link{edge_attr<-}}; \code{\link{edge.attributes}},
  \code{\link{edge_attr}},
  \code{\link{get.edge.attribute}};
  \code{\link{edge_attr_names}},
  \code{\link{list.edge.attributes}};
  \code{\link{get.graph.attribute}},
  \code{\link{graph.attributes}}, \code{\link{graph_attr}};
  \code{\link{graph.attributes<-}},
  \code{\link{graph_attr<-}};
  \code{\link{list.vertex.attributes}},
  \code{\link{vertex_attr_names}};
  \code{\link{set.edge.attribute}},
  \code{\link{set_edge_attr}};
  \code{\link{set.graph.attribute}},
  \code{\link{set_graph_attr}};
  \code{\link{set.vertex.attribute}},
  \code{\link{set_vertex_attr}};
  \code{\link{vertex.attributes<-}},
  \code{\link{vertex_attr<-}}
}

