% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{which_multiple}
\alias{any_multiple}
\alias{count.multiple}
\alias{count_multiple}
\alias{has.multiple}
\alias{is.loop}
\alias{is.multiple}
\alias{which_loop}
\alias{which_multiple}
\title{Find the multiple or loop edges in a graph}
\usage{
which_multiple(graph, eids = E(graph))
}
\arguments{
\item{graph}{The input graph.}

\item{eids}{The edges to which the query is restricted. By default this is
all edges in the graph.}
}
\value{
\code{any_multiple} returns a logical scalar.  \code{which_loop} and
\code{which_multiple} return a logical vector. \code{count_multiple} returns a
numeric vector.
}
\description{
A loop edge is an edge from a vertex to itself. An edge is a multiple edge
if it has exactly the same head and tail vertices as another edge. A graph
without multiple and loop edges is called a simple graph.
}
\details{
\code{which_loop} decides whether the edges of the graph are loop edges.

\code{any_multiple} decides whether the graph has any multiple edges.

\code{which_multiple} decides whether the edges of the graph are multiple
edges.

\code{count_multiple} counts the multiplicity of each edge of a graph.

Note that the semantics for \code{which_multiple} and \code{count_multiple} is
different. \code{which_multiple} gives \code{TRUE} for all occurences of a
multiple edge except for one. Ie. if there are three \code{i-j} edges in the
graph then \code{which_multiple} returns \code{TRUE} for only two of them while
\code{count_multiple} returns \sQuote{3} for all three.

See the examples for getting rid of multiple edges while keeping their
original multiplicity as an edge attribute.
}
\examples{
# Loops
g <- graph( c(1,1,2,2,3,3,4,5) )
which_loop(g)

# Multiple edges
g <- barabasi.game(10, m=3, algorithm="bag")
any_multiple(g)
which_multiple(g)
count_multiple(g)
which_multiple(simplify(g))
all(count_multiple(simplify(g)) == 1)

# Direction of the edge is important
which_multiple(graph( c(1,2, 2,1) ))
which_multiple(graph( c(1,2, 2,1), dir=FALSE ))

# Remove multiple edges but keep multiplicity
g <- barabasi.game(10, m=3, algorithm="bag")
E(g)$weight <- count_multiple(g)
g <- simplify(g)
any(which_multiple(g))
E(g)$weight
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\seealso{
\code{\link{simplify}} to eliminate loop and multiple edges.
}
\keyword{graphs}

