% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/subset.lineupdist.R
\name{subset.lineupdist}
\alias{[.lineupdist}
\alias{subset.lineupdist}
\title{Subsetting distance matrix}
\usage{
\method{subset}{lineupdist}(x, rows, cols, ...)

\method{[}{lineupdist}(x, rows, cols)
}
\arguments{
\item{x}{A distance matrix object as obtained from \code{\link{distee}} or
\code{\link{disteg}}.}

\item{rows}{Optional vector of selected rows.}

\item{cols}{Optional vector of selected columns.}

\item{\dots}{Ignored at this point.}
}
\value{
The input distance matrix object, but with only the specified subset
of the data.
}
\description{
Pull out a specified set of rows and columns from a distance matrix
calculated by \code{\link{distee}} or \code{\link{disteg}}.
}
\examples{
data(expr1, expr2)
\dontshow{expr1 <- expr1[,1:100]; expr2 <- expr2[,1:100]}

# find samples in common
id <- findCommonID(expr1, expr2)

# calculate correlations between cols of x and cols of y
thecor <- corbetw2mat(expr1[id$first,], expr2[id$second,])

expr1s <- expr1[,thecor > 0.8]/1000
expr2s <- expr2[,thecor > 0.8]/1000

# calculate correlations among samples
d <- distee(expr1s, expr2s, d.method="cor")

# pull out distances for samples 24, 92, 44, 66
samp <- c("24", "92", "44", "66")
d[samp, samp]
}
\author{
Karl W Broman, \email{kbroman@biostat.wisc.edu}
}
\seealso{
\code{\link{disteg}}, \code{\link{distee}}, \code{\link{pulldiag}}
}
\keyword{manip}

