% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute-power-by-sample-size.R
\name{computePowerBySampleSize}
\alias{computePowerBySampleSize}
\title{Compute the Power Over a Grid of Sample Size Values}
\usage{
computePowerBySampleSize(V, Delta, min_Delta, alpha = 0.05, sample_size_grid)
}
\arguments{
\item{V}{The covariance matrix of mean EDTR estimators.}

\item{Delta}{The vector of effect sizes with a zero indicating the best EDTR.}

\item{min_Delta}{The minimum desired detectable effect size.}

\item{alpha}{The Type I error rate for not including the true best EDTR.}

\item{sample_size_grid}{The vector of sample sizes}
}
\value{
A vector of power for each sample size in the given grid.
}
\description{
Computes the power over
a grid of sample size values.
}
\details{
It employs common random variables
to reduce the variance. See \code{\link{computePower}} for more details.
}
\examples{

  \donttest{
  V <- rbind(c(1, 0.3, 0.3, 0.3),
             c(0.3, 1, 0.3, 0.3),
             c(0.3, 0.3, 1, 0.3),
             c(0.3, 0.3, 0.3, 1))
  computePowerBySampleSize(V,
                           Delta = c(0, 0.2, 0.6, 0.3),
                           min_Delta = 0.3,
                           sample_size_grid = seq(50,300, 50))
  }
}
\seealso{
\code{\link{computePower}}
}
