% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelFit.R
\name{modelFit}
\alias{modelFit}
\title{Fit a Bayesian Latent Factor to a data set
using STAN}
\usage{
modelFit(
  model = "PLT",
  var.prior = "IG",
  prog = "stan",
  parallel = TRUE,
  Xhisto = NULL,
  nchains = 4,
  nthin = 10,
  niter = 10000,
  R = NULL
)
}
\arguments{
\item{model}{a string indicating the type of model ("PLT", or sparse", default = "PLT")}

\item{var.prior}{the family of priors to use for the variance parameters ("IG" for inverse gamma, or "cauchy")}

\item{prog}{a string indicating the MCMC program to use (default = "stan")}

\item{parallel}{true or false, whether or not to parelleize (done using the package "parallel")}

\item{Xhisto}{matrix of simulated data (projected onto the histogram basis)}

\item{nchains}{number of chains (default = 2)}

\item{nthin}{the number of thinned interations (default = 1)}

\item{niter}{number of iterations (default = 1e4)}

\item{R}{rotation matrix of the same dimension as the number of desired latent factors}
}
\value{
stanfit, a STAN object
}
\description{
Fit a Bayesian Latent Factor to a data set
using STAN
}
\references{
The Stan Development Team Stan Modeling Language User's Guide and Reference Manual. http://mc-stan.org/
}
\author{
Gabrielle Weinrott
}
