% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeanWrapper.R
\name{kmeansCluster}
\alias{kmeansCluster}
\title{K-means Clustering}
\usage{
kmeansCluster(data = NULL, ...)
}
\arguments{
\item{data}{A Data set}

\item{\dots}{center: The number of centers}
}
\value{
A list of cluster labels and a R object of class "kmeans"
}
\description{
This function classifies unlabeled data by grouping them by features,
rather than pre-defined categories. It splits the data into K different
clusters and describes the location of the center of each cluster. Then,
a new data point can be assigned a cluster (class) based on the closed
center of mass.
}
\examples{
library(datasets)
data(iris)

rndSamples <- sample(nrow(iris),100)
trainData <- iris[rndSamples,]
testData <- iris[-rndSamples,]

cls <- kmeansCluster(trainData[,1:4],3)
}
