% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moving_window.R
\name{moving_window}
\alias{moving_window}
\title{Summarize data within windows of time}
\usage{
moving_window(Dataframe, Trial, Window.length, FUN = mean)
}
\arguments{
\item{Dataframe}{a GCalcium-format data frame or matrix}

\item{Trial}{a single trial number}

\item{Window.length}{length of time each window encompasses}

\item{FUN}{a function to apply to each window}
}
\value{
a data frame with start and stop times of each window, the chronological number of each window, and summarized values
}
\description{
`moving_window` summarizes data within windows of a certain length.
}
\examples{
### Format data frame
df.new <- format_data(GCaMP)

### In trial 5, how does the average fluorescence change in 1 second time frames?
moving_window(Dataframe = df.new, Trial = 5, Window.length = 1, FUN = mean)
}
