% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nrspGTDL.R
\name{nrsp.GTDL}
\alias{nrsp.GTDL}
\title{Normally-transformed randomized survival 
probability residuals for the GTDL model}
\usage{
nrsp.GTDL(t, formula, pHat, censur)
}
\arguments{
\item{t}{non-negative random variable representing the failure time and leave the snapshot failure rate, or danger.}

\item{formula}{The structure matrix of covariates of dimension n x p.}

\item{pHat}{Estimate of the parameters from the GTDL model.}

\item{censur}{Censoring status 0=censored, a=fail.}
}
\value{
Normally-transformed randomized survival 
probability residuals
}
\description{
Normally-transformed randomized survival 
probability residuals for the GTDL model
}
\examples{

### Example 1

require(survival)
data(lung)
lung <- lung[-14,]
lung$sex <- ifelse(lung$sex==2, 1, 0)
lung$ph.ecog[lung$ph.ecog==3]<-2
t1 <- lung$time
formula1 <- ~lung$sex+factor(lung$ph.ecog)+lung$age
censur1 <- ifelse(lung$status==1,0,1)
start1 <- c(0.03,0.05,-1,0.7,2,-0.1)
fit.model1 <- mle2.GTDL(t = t1,start = start1,
           formula = formula1,
           censur = censur1)
r1 <- nrsp.GTDL(t = t1,formula = formula1 ,pHat = fit.model1$Coefficients[,1],
             censur = censur1)
r1

### Example 2

data(tumor)
t2 <- tumor$time
formula2 <- ~tumor$group
censur2 <- tumor$censured
start2 <- c(1,-0.05,1.7)
fit.model2 <- mle2.GTDL(t = t2,start = start2,
                       formula = formula2,
                       censur = censur2)
r2 <- nrsp.GTDL(t = t2,formula = formula2, pHat = fit.model2$Coefficients[,1],
            censur = censur2)
r2
}
\references{
\itemize{
\item Li, L., Wu, T., e Cindy, F. (2021). Model diagnostics for censored regression via randomized
survival probabilities. Statistics in Medicine, 40, 1482–1497.
\item de Oliveira, L. E. F., dos Santos L. S., da Silva, P. H. F., Fabio, L. C.,
Carrasco, J. M. F.(2022).  Análise de resíduos para o modelo logístico 
generalizado dependente do tempo (GTDL). Submitted. 
}
}
