% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantileGTDL.R
\name{random.quantile.GTDL}
\alias{random.quantile.GTDL}
\title{Randomized quantile residuals for the GTDL model}
\usage{
random.quantile.GTDL(t, formula, pHat, censur)
}
\arguments{
\item{t}{non-negative random variable representing the failure time and leave the snapshot failure rate, or danger.}

\item{formula}{The structure matrix of covariates of dimension n x p.}

\item{pHat}{Estimate of the parameters from the GTDL model.}

\item{censur}{censoring status 0=censored, a=fail.}
}
\value{
Randomized quantile residuals
}
\description{
Randomized quantile residuals for the GTDL model
}
\details{
The randomized quantile residual (Dunn and Smyth, 1996), 
which follow a standard normal distribution is used to assess 
departures from the GTDL model.
}
\examples{

### Example 1

require(survival)
data(lung)
lung <- lung[-14,]
lung$sex <- ifelse(lung$sex==2, 1, 0)
lung$ph.ecog[lung$ph.ecog==3]<-2
t1 <- lung$time
formula1 <- ~lung$sex+factor(lung$ph.ecog)+lung$age
censur1 <- ifelse(lung$status==1,0,1)
start1 <- c(0.03,0.05,-1,0.7,2,-0.1)
fit.model1 <- mle2.GTDL(t = t1,start = start1,
           formula = formula1,
           censur = censur1)
r1 <- random.quantile.GTDL(t = t1,formula = formula1 ,pHat = fit.model1$Coefficients[,1],
             censur = censur1)
r1

### Example 2

data(tumor)
t2 <- tumor$time
formula2 <- ~tumor$group
censur2 <- tumor$censured
start2 <- c(1,-0.05,1.7)
fit.model2 <- mle2.GTDL(t = t2,start = start2,
                       formula = formula2,
                       censur = censur2)
r2 <- random.quantile.GTDL(t = t2,formula = formula2, pHat = fit.model2$Coefficients[,1],
            censur = censur2)
r2
}
\references{
\itemize{
\item Dunn, P. K. e Smyth, G. K. (1996). Randomized quantile residuals. Journal of Computational
and Graphical Statistics, 5, 236–244.
\item Louzada, F., Cuminato, J. A., Rodriguez, O. M. H., Tomazella, V. L. D., Milani, E. A., 
Ferreira, P. H., Ramos, P. L., Bochio, G., Perissini, I. C., Junior, O. A. G., Mota, A. L., Alegr´ıa, 
L. F. A., Colombo, D., Oliveira, P. G. O., Santos, H. F. L., e Magalh˜aes, M. V. C. (2020). 
Incorporation of frailties into a non-proportional hazard regression model and its diagnostics 
for reliability modeling of downhole safety valves. IEEE Access, 8, 219757 – 219774.
\item de Oliveira, L. E. F., dos Santos L. S., da Silva, P. H. F., Fabio, L. C.,
Carrasco, J. M. F.(2022).  Análise de resíduos para o modelo logístico 
generalizado dependente do tempo (GTDL). Submitted. 
}
}
