% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.metrics.R
\name{graph.metrics}
\alias{graph.metrics}
\title{Graph Metrics}
\usage{
graph.metrics(
  x,
  node.pts,
  node.name = NULL,
  direct = FALSE,
  metric = c("betweenness", "degree", "closeness")
)
}
\arguments{
\item{x}{knn graph object from GeNetIt::knn.graph (sf LINESTRING)}

\item{node.pts}{sf POINT or sp SpatialPointsDataFrame object used as nodes to build x}

\item{node.name}{Column name in node.pts object that acts as the provides the unique ID.
If not defined, defaults to row.names of node.pts}

\item{direct}{(FALSE/TRUE) Evaluate directed graph}

\item{metric}{...}
}
\description{
Metrics on structural properties of graph (at nodes)
}
\note{
Please note; graph metrics are not valid for a saturated graph (all connections)
}
\examples{
 library(sf)
 data(ralu.site, package="GeNetIt")

 graph <- knn.graph(ralu.site, row.names=ralu.site$SiteName, 
                   max.dist = 2500)
     plot(st_geometry(graph))

 ( m <- graph.metrics(graph, ralu.site, "SiteName") )
 
  ralu.site <- merge(ralu.site, m, by="SiteName")
    # plot node betweenness
    plot(st_geometry(graph), col="grey")
   plot(ralu.site["betweenness"], pch=19, cex=1.25, add=TRUE)
# plot node degree
    plot(st_geometry(graph), col="grey")
   plot(ralu.site["degree"], pch=19, cex=1.25, add=TRUE)	   

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org> and 
        Melanie A. Murphy <melanie.murphy@uwyo.edu>
}
