% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gravity.R
\name{gravity}
\alias{gravity}
\title{Gravity model}
\usage{
gravity(
  y,
  x,
  d,
  group,
  data,
  fit.method = c("REML", "ML"),
  ln = TRUE,
  constrained = TRUE,
  ...
)
}
\arguments{
\item{y}{Name of dependent variable}

\item{x}{Character vector of independent variables}

\item{d}{Name of column containing distance}

\item{group}{Name of grouping column (from or to)}

\item{data}{data.frame object containing model data}

\item{fit.method}{Method used to fit model c("REML", "ML")}

\item{ln}{Natural log transform data (TRUE/FALSE)}

\item{constrained}{Specify constrained model, if FALSE a linear model (lm) 
is run (TRUE/FALSE)}

\item{...}{Additional argument passed to nlme or lm}
}
\value{
formula           Model formula call

fixed.formula     Model formula for fixed effects

random.formula    Model formula for random (group) effects 
                          (only for constrained models)

gravity           Gravity model

fit               Model Fitted Values

AIC               AIC value for selected model

RMSE              Root Mean Squared Error (based on bias corrected back transform)

log.likelihood    Restricted log-likelihood at convergence

group.names       Column name of grouping variable

groups            Values of grouping variable

x                 data.frame of x variables

y                 Vector of y variable

constrained       TRUE/FALSE indicating if model is constrained
}
\description{
Implements Murphy et al., (2010) gravity model via a 
             linear mixed effects model
}
\details{
The "group" factor defines the singly constrained direction (from or to) and the 
grouping structure for the origins. To specify a null (distance only or IBD) 
model just omit the x argument. 

By default constrained models are fit by maximizing the restricted log-likelihood 
(REML), for maximum likelihood use the type="ML" argument which is passed to the 
lme function. If ln=TRUE the input data will be log transformed
}
\note{
Depends: nlme, lattice
}
\examples{
library(nlme)
data(ralu.model)

# Gravity model	
x = c("DEPTH_F", "HLI_F", "CTI_F", "cti", "ffp")
( gm <- gravity(y = "DPS", x = x, d = "DISTANCE", group = "FROM_SITE", 
                data = ralu.model, ln = FALSE) )

#' # Plot gravity results
 par(mfrow=c(2,3))
   for (i in 1:6) { plot(gm, type=i) } 

# log likelihood of competing models 
 x = c("DEPTH_F", "HLI_F", "CTI_F", "cti", "ffp")
 for(i in x[-1]) {
   x1 = c(x[1], x[-which(x \%in\% i)])  
   ll <- gravity(y = "DPS", x = x1, d = "DISTANCE", group = "FROM_SITE", 
                 data = ralu.model, ln = FALSE)$log.likelihood
  cat("log likelihood for parameter set:", "(",x1,")", "=", ll, "\n") 
 }

# Distance only (IBD) model
gravity(y = "DPS", d = "DISTANCE", group = "FROM_SITE", 
        data = ralu.model, ln = FALSE)

}
\references{
Murphy, M. A. & J.S. Evans. (in prep). GenNetIt: graph theoretical gravity modeling 
  for landscape genetics

Murphy M.A., R. Dezzani, D.S. Pilliod & A.S. Storfer (2010) Landscape genetics of 
  high mountain frog metapopulations. Molecular Ecology 19(17):3634-3649
}
\seealso{
\code{\link[nlme]{groupedData}} for how grouping works in constrained model

\code{\link[nlme]{lme}} for constrained model ... options

\code{\link[stats]{lm}} for linear model ... options
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org> and 
        Melanie A. Murphy <melanie.murphy@uwyo.edu>
}
