% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{config}
\alias{config}
\title{Create a \code{config} object}
\usage{
config(
  cycle,
  initial_population,
  preds = NULL,
  steps = 365L,
  max_duration = 365L,
  verbose = TRUE
)
}
\arguments{
\item{cycle}{A tick's \code{\link{life_cycle}} test}

\item{initial_population}{Named numeric vector indicating starting population
for each life stage. Life stages not specified are assumed to be 0.}

\item{preds}{Optional input \code{\link{predictors}} data}

\item{steps}{Numeric vector of length one indicating the duration to run the
model over in days.}

\item{max_duration}{Numeric vector of length one. Determines the maximum
number of days that a duration-based transition can last, after which ticks
are removed from the model/die. Default of 365 is likely sensible for most
cases.}

\item{verbose}{Boolean; whether to warn about coercion to inputs}
}
\value{
A \code{config} object
}
\description{
Make a \code{config} object from the input parameters, and ensure that the inputs
meet the requirements for the model. The returned object is a complete
description of a model run scenario.
}
\examples{
# We build a simple example config
my_config <- config(
  cycle = life_cycle(
    transition("a", "b", function() 0.1, "probability"),
    transition("b", "a", function() 10, "probability")
  ),
  initial_population = c(a = 1)
)

# If we make a change to an existing `config`, it is a good idea to check
# whether it is still valid by calling `config()` on it again. For example,
# here we set the initial_population of a life stage that is not included in
# the life cycle.
my_config$initial_population <- c(a = 1, c = 1)

\dontrun{
# Now, we re-run the validations, which will throw an error
do.call(config, my_config)
}

}
