% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KFPLS.R
\name{KFPLS}
\alias{KFPLS}
\title{Kernel functional partial least squares method}
\usage{
KFPLS(X, Y, obser_time, nfold, n_comp, sigm_list, basis)
}
\arguments{
\item{X}{An \code{array} with three indices. The (i, j, k)-th element of it corresponds to the measurment of the i-th subject for the k-th functional predictor at j-th observation grid.}

\item{Y}{A \code{vector} with length n, where n is the sample size. The i-th element of it corresponds to the measurement of the scalar response for the i-th subject.}

\item{obser_time}{A \code{vector} denoting the observation times of the functional predictors.}

\item{nfold}{An \code{integer} denoting the number of folds for the selection of the tuning parameters by cross-validation.}

\item{n_comp}{A \code{vector} denoting the candidates of the number of components.}

\item{sigm_list}{A \code{vector} denoting the candidates of the tuning parameter for the Gaussian kernel.}

\item{basis}{A basis object denoting the basis that used for the smoothing of the functional predictors. It is created by functions in \code{fda} package, such as \code{\link[fda]{create.bspline.basis}}.}
}
\value{
A \code{list} containing the following components:
\item{n}{A \code{scalar} denoting the sample size.}
\item{p}{A \code{scalar} denoting the number of functional predictors.}
\item{nk}{A \code{scalar} denoting the selected number of components.}
\item{T}{A \code{matrix} denoting the value of T at convergence.}
\item{U}{A \code{matrix} denoting the value of U at convergence.}
\item{K}{A \code{matrix} denoting the Gram matrix.}
\item{K_c}{A \code{matrix} denoting the centralized Gram matrix.}
\item{Xfd_list}{A \code{list} of length \code{p}. The k-th entry corresponds to the functional data object of the k-th functional predictor.}
\item{XX_list}{A \code{list} of length \code{p}. The k-th entry corresponds to the matrix that denotes the inner product of the k-th functional predictor for all subjects.}
\item{Y_c}{A \code{vector} denoting the centralized scalar response.}
\item{meanY}{A \code{scalar} denoting the sample mean of the scalar response.}
\item{Y_hat}{A \code{vector} denoting the prediction of the scalar response.}
\item{obser_time}{A \code{vector} denoting the observation times of the functional predictors.}
\item{basis}{A basis object denoting the basis that used for the smoothing of the functional predictors.}
\item{sigm}{A \code{scalar} denoting the selected tuning parameter for the Gaussian kernel.}
\item{CVscore}{A \code{matrix} denoting the CV scores.}
\item{time}{A \code{scalar} denoting the computation time.}
}
\description{
Kernel functional partial least squares (KFPLS) method for functional nonlinear models with scalar response and functional predictors. The Gaussian kernel is used.
}
\examples{
# Generate data
n <- 200
t_range <- c(0, 1)
obser_time <- seq(0, 1, length.out = 51)
beta_fun <- function(t){2 * sin(2 * pi * t)}
basis <- fda::create.bspline.basis(t_range, nbasis = 13, norder = 4,
breaks = seq(0, 1, length.out = 11))
beta_fd <- fda::smooth.basis(obser_time, beta_fun(obser_time), basis)$fd
X_basis <- fda::create.bspline.basis(t_range, nbasis = 23, norder = 4,
breaks = seq(0, 1, length.out = 21))
Bbeta <- fda::inprod(X_basis, beta_fd)
Xi_B <- splines::bs(obser_time, knots = seq(0, 1, length.out = 21)[-c(1, 21)],
degree = 3, intercept = TRUE)
a <- array(0, dim = c(n, 23, 1))
X <- array(0, dim = c(n, 51, 1))
Y <- NULL
for(i in 1:n){
a[i, , 1] <- stats::rnorm(23)
X[i, , 1] <- Xi_B \%*\% a[i, , 1]
aBbeta <- as.numeric(t(a[i, , 1]) \%*\% Bbeta)
Y[i] <- aBbeta + stats::rnorm(1, mean = 0, sd = 0.05)
}
# KFPLS
KFPLS_list <- KFPLS(X, Y, obser_time, nfold = 5, n_comp = 5, sigm_list = 0.005, basis)
plot(KFPLS_list$Y_hat, Y)
lines(Y, Y)
}
