% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NRejections.R
\name{corr_tests}
\alias{corr_tests}
\title{Global evidence strength across correlated tests}
\usage{
corr_tests(
  d,
  X,
  C = NA,
  Ys,
  B = 2000,
  cores,
  alpha = 0.05,
  alpha.fam = 0.05,
  method = "nreject"
)
}
\arguments{
\item{d}{Dataframe}

\item{X}{Single quoted name of covariate of interest}

\item{C}{Vector of quoted covariate names}

\item{Ys}{Vector of quoted outcome names}

\item{B}{Number of resamples to generate}

\item{cores}{Number of cores to use for parallelization. Defaults to number available.}

\item{alpha}{Alpha level for individual hypothesis tests}

\item{alpha.fam}{Alpha level for global test and null interval}

\item{method}{Which methods to report (ours, Westfall's two methods, Bonferroni, Holm, Romano)}
}
\value{
\code{samp.res} is a list containing the number of observed rejections (\code{rej}), 
the coefficient estimates of interest for each outcome model (\code{bhats}), their t-values
(\code{tvals}), their uncorrected p-values at level \code{alpha} (\code{pvals}), and an N X W matrix of 
residuals for each model (\code{resid}).

\code{nrej.bt} contains the number of rejections in each bootstrap resample. 

\code{tvals.bt} is a W X B matrix containing t-values for the resamples.

\code{pvals.bt} is a W X B matrix containing p-values for the resamples.

\code{null.int} contains the lower and upper limits of a 100*(1 - \code{alpha.fam}) percent null interval.

\code{excess.hits} is the difference between the observed rejections and the upper limit of the null interval.

\code{global.test} is a dataframe containing global test results for each user-specified method, including
an indicator for whether the test rejects the global null at \code{alpha.fam} (\code{reject}), the p-value
of the global test where possible (\code{reject}), and the critical value of the global test based on the number
of rejections (\code{crit}).
}
\description{
This is the main wrapper function for the user to call. For an arbitrary number of outcome variables, regresses the outcome
on an exposure of interest (\code{X}) and adjusted covariates (\code{C}). Returns the results of the original sample
(statistics and inference corresponding to X for each model, along with the observed number of rejections),
a 100*(1 - \code{alpha.fam}) percent null interval for the
number of rejections in samples generated under the global null, the excess hits
(the difference between the observed number of rejections and the upper null interval limit), 
and results of a test of the global null hypothesis at \code{alpha.fam} of the global null. The global test 
can be conducted based on the number of rejections or based on various FWER-control methods (see References).
}
\examples{
\donttest{
##### Example 1 #####
data(rock)

res = corr_tests( d = rock,
                 X = c("area"),
                 C = NA,
                 Ys = c("perm", "peri", "shape"),
                 method = "nreject" )

# mean rejections in resamples
# should be close to 0.05 * 3 = 0.15
mean( as.numeric(res$nrej.bt) ) }

\donttest{
##### Example 1 #####
cor = make_corr_mat( nX = 10,
nY = 20,
rho.XX = 0.10,
rho.YY = 0.5,
rho.XY = 0.1,
prop.corr = .4 )

d = sim_data( n = 300, cor = cor )

# X1 is the covariate of interest, and all other X variables are adjusted
all.covars = names(d)[ grep( "X", names(d) ) ]
C = all.covars[ !all.covars == "X1" ]

# may take 10 min to run
res = corr_tests( d,
                 X = "X1",
                 C = C,
                 Ys = names(d)[ grep( "Y", names(d) ) ],
                 method = "nreject" )

# look at the main results
res$null.int
res$excess.hits
res$global.test
}
}
\references{
Mathur, M.B., & VanderWeele, T.J. (in preparation). New metrics for multiple testing with correlated
outcomes.

Romano, J. P., & Wolf, M. (2007). Control of generalized error rates in multiple testing. The
Annals of Statistics, 1378-1408.

Westfall, P. H., & Young, S. S. (1993). Resampling-based multiple testing: Examples and
methods for p-value adjustment. Taylor & Francis Group.
}
