% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo.absent.points.R
\name{pseudo.absent.points}
\alias{pseudo.absent.points}
\title{Generation of pseudo absent points for niche model building}
\usage{
pseudo.absent.points(data, outputNum = 500, en.vir = NULL, map = TRUE)
}
\arguments{
\item{data}{Data frame, longitude and latitude of a single species.}

\item{outputNum}{Numeric, the expected number of points.}

\item{en.vir}{RasterBrick, the globle bioclimate data obtained from
"raster::getData" function.}

\item{map}{Logical. Should a map be drawn?}
}
\value{
A data frame of simulated pseudo points.

A data frame of bioclimate variables of each pseudo points.
}
\description{
Randomly generate pseudo points outside the 95\%CI of the
ecological space of the present data when there is no absent data for
building a niche model.
}
\examples{
data(en.vir)
#envir<-raster::getData("worldclim",download=FALSE,var="bio",res=2.5)
#en.vir<-raster::brick(envir)

data<-data.frame(species=rep("Acosmeryx anceus",3),
                 Lon=c(145.380,145.270,135.461),
                 Lat=c(-16.4800,-5.2500,-16.0810))

absent.points<-pseudo.absent.points(data,en.vir=en.vir,outputNum=100)
head(absent.points$lonlat)
head(absent.points$envir)
}
\author{
Cai-qing YANG (Email: yangcq_ivy(at)163.com) and Ai-bing ZHANG
(Email:zhangab2008(at)cnu.edu.cn), Capital Normal University (CNU), Beijing,
CHINA.
}
\keyword{pseudo.absent.points}
