% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenTab3.R
\name{GenTab3}
\alias{GenTab3}
\title{Three-way contingency table r x c x t  - generation}
\usage{
GenTab3(pijt, n)
}
\arguments{
\item{pijt}{a numeric matrix with non-negative probability values of the three-way contingency table}

\item{n}{a sample size}
}
\value{
The function returns the three-way contingency table r x c x t
}
\description{
Generating a three-way contingency table r x c x t.
}
\details{
Generating a three-way contingency table r x c x t using the probability matrix pijt.
If Ho is true then pijt equals 1 / r / c / t.
}
\examples{
r = 2; c = 3; t = 4
GenTab3(array(1 / (r * c * t), dim = c(r, c, t)),250)
table = GenTab3(array(0.125, dim = c(2, 2, 2)), 100)
GenTab3(prop.table(table),100)

}
\references{
{Sulewski, P. (2018). \emph{Power Analysis Of Independence Testing for the Three-Way Con-tingency Tables of Small Sizes.} Journal of Applied Statistics 45(13), 2481-2498}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
