% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lms3.pvalue.R
\name{Lms3.pvalue}
\alias{Lms3.pvalue}
\title{Logarithmic minimum test for independence in three-way contingency table}
\usage{
Lms3.pvalue(stat, nr, nc, nt, n, B = 10000)
}
\arguments{
\item{stat}{a Logarithmic minimum statistic value}

\item{nr}{a number of rows}

\item{nc}{a number of columns}

\item{nt}{a number of tubes}

\item{n}{a sample size}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns the p-value of the logarithmic minimum test.
}
\description{
Calculates the p-value of the Logarithmic minimum test for independence in three-way contingency table
}
\details{
The Critical value of the modular test for independence in r x c x t contingency table,
}
\examples{
tab1 = GenTab3(array(0.125, dim = c(2, 2, 2)), 100)
Lms3.pvalue(Lms3.stat(tab1), 2, 2, 2, 100, B=1e2)
Lms3.pvalue(Lms3.stat(table4), 2, 2, 2, 80, B = 1e3)

}
\references{
{Sulewski, P. (2021). \emph{Logarithmic Minimum Test for Independence in Three Way Con-tingency Table of Small Sizes,} Journal of Statistical Computation and Simulation 91(13), 2780-2799}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
