#' Computing, Fitting and Validating the PPS Distribution
#'
#' Statistical functions to describe a Pareto Positive Stable (PPS) 
#' distribution and fit it to real data. Graphical and statistical tools to
#' validate the fits are included.
#'
#' The main function you're likely to need from \pkg{ParetoPosStable} is
#' \code{\link{PPS.fit}}, in order to obtain a PPS fit from data. Validation can be obtain with \code{\link{GoF}} and \code{\link{plot}}.
#'
#' @docType package
#' 
#' @name ParetoPosStable
#' 
#' @references Sarabia, J.M and Prieto, F. (2009). The Pareto-positive stable
#' distribution: A new descriptive model for city size data, \emph{Physica A:
#' Statistical Mechanics and its Applications}, \bold{388}(19), 4179-4191.
NULL