% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/validation.R
\name{GoF}
\alias{GoF}
\alias{GoF.default}
\title{Goodness of fit tests for the Pareto Positive Stable (PPS) distribution}
\usage{
GoF(PPSfit, k = 2000, parallel = TRUE, ncores = 2, ...)
}
\arguments{
\item{PPSfit}{A \code{PPSfit} Object.}

\item{k}{The number of iterations in the bootstrap procedure to approximate the p-values.}

\item{parallel}{A logical argument specifying if parallelization is allowed in the bootstrap iteration procedure.}

\item{ncores}{is the number of cores that we use if parallel is TRUE.}

\item{\dots}{Other arguments.}
}
\value{
A list with the values of the tests statistics and the approximated p-values.
}
\description{
Kolmogorov-Smirnov, Anderson-Darling and PPS goodness of fit tests to validate a PPS fit (typically from \code{PPS.fit()}).
}
\details{
It returns the Kolmogorov-Smirnov, the Anderson-Darling tests and a specific test for PPS distributions. p-values are approximated by a bootstrap procedure.
The specific goodness of fit test for PPS distributions is based on the linearity of the survival function vs. the scaled observations in a double log-log scale (see Sarabia and Prieto, 2009).
}
\examples{
x <- rPPS(50, 1.2, 100, 2.3)
fit <- PPS.fit(x)
GoF(fit, k = 50)
}
\references{
Sarabia, J.M and Prieto, F. (2009). The Pareto-positive stable distribution: A new descriptive model for city size data, \emph{Physica A: Statistical Mechanics and its Applications}, \bold{388}(19), 4179-4191.
}
\seealso{
\code{\link{PPS.fit}}, \code{\link{plot.PPSfit}}
}

