% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/investport.R
\name{FixBacktest}
\alias{FixBacktest}
\title{Buy and Hold Backtest}
\usage{
FixBacktest(rets, weights)
}
\arguments{
\item{rets}{historic multivariate returns}

\item{weights}{holding weights of stock}
}
\value{
A backtest return series
}
\description{
Backtest for the buy and hold with a fixed weights strategy.
}
\examples{
names <- c("swan", "bear", "tiger")
date <- as.Date("2015-01-01") + days(0:179)
mu <- c(0.2, 0.08, 0.1)
sigma <- matrix(c(1, 0.25, -0.3, 0.25, 0.25, 0, -0.3, 0, 0.36), 3, 3)
allret <- rMvReturnSim(names, date, mu, sigma)
tsret <- as.timeSeries(allret)
FixBacktest(tsret, rep(1 / 3, 3))
}
