% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_procrustes.R
\name{realignMap}
\alias{realignMap}
\title{Realign map to match another}
\usage{
realignMap(map, target_map, translation = TRUE, scaling = FALSE)
}
\arguments{
\item{map}{The acmap to realign.}

\item{target_map}{The acmap to realign to.}

\item{translation}{Should translation be allowed}

\item{scaling}{Should scaling be allowed (generally not recommended unless
comparing maps made with different assays)}
}
\value{
Returns a map object aligned to the target map
}
\description{
Realigns the coordinates of a map to match a target map as closely as
possible, based on a
\href{https://en.wikipedia.org/wiki/Procrustes_analysis}{procrustes analysis}.
Note that all optimization runs will be separately aligned to match as
closely as possible the first optimization run of the target map.
}
\seealso{
Other functions to compare maps: 
\code{\link{matchStrains}},
\code{\link{procrustesData}()},
\code{\link{procrustesMap}()},
\code{\link{realignOptimizations}()}
}
\concept{functions to compare maps}
