% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEPaLS.R
\name{maximum_Likelihood_SEPaLS}
\alias{maximum_Likelihood_SEPaLS}
\title{Maximum Likelihood estimator}
\usage{
maximum_Likelihood_SEPaLS(X, Y, yn)
}
\arguments{
\item{X}{\eqn{(n\times p)}-dimensional matrix of the covariates.}

\item{Y}{\eqn{(n)}-dimensional vector of the response.}

\item{yn}{the quantile corresponding to the lowest values of \eqn{Y}s to put
in the tail.}
}
\value{
The maximum likelihood estimator.
}
\description{
Maximum Likelihood estimator
}
\examples{
n <- 3000
p <- 10
X <- matrix(rnorm(n*p),n,p)
beta <- c(5:1,rep(0,p-5)) ; beta <- beta/sqrt(sum(beta^2))
Y <- X\%*\%beta + rnorm(n,sd=1/3)
estimators <- do.call(rbind,lapply(seq(0,1,length.out=100),function(pp){
  yn <- quantile(Y,probs = pp)
  maximum_Likelihood_SEPaLS(X,Y,yn)
}))
matplot(estimators,type="l",lty=1,col=c(rep(2,5),rep(1,p-5)))
abline(h=beta/sqrt(sum(beta^2)),col=c(rep(2,5),rep(1,p-5)))
}
