% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_to_path.R
\name{network_to_path}
\alias{network_to_path}
\title{Path model from ordered precision matrix}
\usage{
network_to_path(omega, input_type = "precision", digits = 20)
}
\arguments{
\item{omega}{input matrix, with rows and columns in desired topological ordering
Must be an invertible square matrix}

\item{input_type}{specifies what type of matrix `omega` is.
 default is "precision", other options include a matrix of partial correlations
("parcor") or a covariance matrix "covariance"}

\item{digits}{desired rounding of the output matrix}
}
\value{
lower triangular matrix containing regression weights of the path model.
  Element ij represents the effect of \eqn{X_j} on \eqn{X_i}
}
\description{
Takes a precision matrix and generates a lower-triangular weights matrix.
}
\examples{
data(riskcor)
omega <- (qgraph::EBICglasso(riskcor, n = 69, returnAllResults = TRUE))$optwi
# qgraph method estimates a non-symmetric omega matrix, but uses forceSymmetric to create
# a symmetric matrix (see qgraph:::EBICglassoCore line 65)
omega <- as.matrix(Matrix::forceSymmetric(omega)) # returns the precision matrix

B <- network_to_path(omega, digits=2)

# Path model can be plotted as a weighted DAG
pos <- matrix(c(2,0,-2,-1,-2,1,0,2,0.5,0,0,-2),6,2,byrow=TRUE)

# qgraph reads matrix elements as "from row to column"
# regression weights matrices are read "from column to row"
# path model weights matrix must be transposed for qgraph
qgraph::qgraph(t(B), labels=rownames(riskcor), layout=pos,
repulsion=.8, vsize=c(10,15), theme="colorblind", fade=FALSE)

}
\references{
\insertRef{ryan2019}{SEset}

    \insertRef{shojaie2010penalized}{SEset}

    \insertRef{bollen89sem}{SEset}
}
\seealso{
\code{\link{network_to_SEset}}
}
