% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration_fixedSSD.R
\name{integration_fixedSSD}
\alias{integration_fixedSSD}
\title{SSRT using integration method for studies with "fixed" method of setting SSD}
\usage{
integration_fixedSSD(df, stop_col, rt_col, acc_col, ssd_col, ssd_list)
}
\arguments{
\item{df}{Dataframe with response time, accuracy, indication whether trial is stop or go, and delays for a given trial.}

\item{stop_col}{Name of the column in the dataframe \code{df} that indicates whether a given trial is a "stop" or a "go" trial ( 0 = go, 1 = stop)}

\item{rt_col}{Name of the column in the dataframe \code{df} that contains response time in seconds}

\item{acc_col}{Name of the column in the dataframe \code{df} that contains accuracy of inhibition ( 0 = incorrect, 1 = correct)}

\item{ssd_col}{Name of the column in the dataframe \code{df} that contains stop-signal delays}

\item{ssd_list}{List of stop-signal delays used in the experiment}
}
\value{
SSRT corresponding to the \code{nth rt - ssd; n = p(respond|signal)*number of goRTs}
}
\description{
Estimating SSRT using integration method for studies that use fixed (randomly chosen on each trial from a pre-determined set) stop-signal delays.
}
\examples{
data(fixed)
sapply(split(fixed, fixed$new_id), integration_fixedSSD, stop_col = 'vol',acc_col ='acc',
rt_col = 'RT_exp', ssd_col = 'soa',ssd_list = c(0.1, 0.2,0.3, 0.4, 0.5, 0.6))
}
