% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS.R
\name{pTSS}
\alias{pTSS}
\title{Cumulative probability distribution function of the tempered stable subordinator
distribution}
\usage{
pTSS(
  q,
  alpha = NULL,
  delta = NULL,
  lambda = NULL,
  theta = NULL,
  pmethod = "integrate",
  N = 8192,
  ...
)
}
\arguments{
\item{q}{A numeric vector of positive quantiles.}

\item{alpha}{Stability parameter. A real number between 0 and 1.}

\item{delta}{Scale parameter. A real number > 0.}

\item{lambda}{Tempering parameter. A real number > 0.}

\item{theta}{Parameters stacked as a vector.}

\item{pmethod}{A string. If not "integrate", the function \code{chartocdf()}
will be triggered.}

\item{N}{is a power of two & N >= 1024. if
\code{pmethod != "integrate"}. 8192 by default. Relevant for}

\item{...}{Possibility to modify \code{stats::integrate()}.}
}
\value{
As \code{q} is a numeric vector, the return value is also a numeric
vector of probabilities.
}
\description{
The cumulative probability distribution function (CDF) of the tempered
stable subordinator distribution.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, delta, lambda)}. Either provide the parameters
\code{alpha}, \code{delta}, \code{lambda} individually OR provide \code{theta}.
The function integrates the PDF numerically with \code{integrate()}.
}
\examples{
\donttest{
x <- seq(0,15,0.5)
y <- pTSS(x,0.7,1.354,0.3)
plot(x,y)
}

}
\seealso{
See also the \code{\link[=dTSS]{dTSS()}} density-function.
}
