% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_all_tweets.R
\name{count_all_tweets}
\alias{count_all_tweets}
\title{Count tweets from full archive search}
\usage{
count_all_tweets(
  query = NULL,
  start_tweets,
  end_tweets,
  bearer_token = get_bearer(),
  n = 100,
  file = NULL,
  data_path = NULL,
  export_query = TRUE,
  bind_tweets = TRUE,
  granularity = "day",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{query}{string or character vector, search query or queries}

\item{start_tweets}{string, starting date}

\item{end_tweets}{string, ending date}

\item{bearer_token}{string, bearer token}

\item{n}{integer, upper limit of tweet counts to be fetched (i.e., for 365 days n must be at least 365). Default is 100.}

\item{file}{string, name of the resulting RDS file}

\item{data_path}{string, if supplied, fetched data can be saved to the designated path as jsons}

\item{export_query}{If \code{TRUE}, queries are exported to data_path}

\item{bind_tweets}{If \code{TRUE}, tweets captured are bound into a data.frame for assignment}

\item{granularity}{string, the granularity for the search counts results. Options are "day"; "hour"; "minute". Default is day.}

\item{verbose}{If \code{FALSE}, query progress messages are suppressed}

\item{...}{arguments will be passed to \code{build_query()} function. See \code{?build_query()} for further information.}
}
\value{
a data.frame
}
\description{
This function returns aggregate counts of tweets by query string or strings
between specified date ranges.
}
\examples{
\dontrun{

count_all_tweets(query = "Hogmanay", 
          start_tweets = "2019-12-2700:00:00Z", 
          end_tweets = "2020-01-05T00:00:00Z", 
          bearer_token = get_bearer())
          
count_all_tweets(query = "Hogmanay", 
          start_tweets = "2019-12-27T00:00:00Z", 
          end_tweets = "2020-01-05T00:00:00Z", 
          bearer_token = get_bearer(),
          granularity = "hour",
          n = 500)
}
}
