% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_functions.R
\name{get_bbox_tweets}
\alias{get_bbox_tweets}
\title{Get tweets within bounding box
`r lifecycle::badge("deprecated")}
\usage{
get_bbox_tweets(
  query,
  bbox,
  start_tweets,
  end_tweets,
  bearer_token = get_bearer(),
  n = 100,
  file = NULL,
  data_path = NULL,
  bind_tweets = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{query}{string or character vector, search query or queries}

\item{bbox}{numeric, a vector of four bounding box coordinates from west longitude to north latitude}

\item{start_tweets}{string, starting date}

\item{end_tweets}{string, ending date}

\item{bearer_token}{string, bearer token}

\item{n}{integer, upper limit of tweets to be fetched}

\item{file}{string, name of the resulting RDS file}

\item{data_path}{string, if supplied, fetched data can be saved to the designated path as jsons}

\item{bind_tweets}{If \code{TRUE}, tweets captured are bound into a data.frame for assignment}

\item{verbose}{If \code{FALSE}, query progress messages are suppressed}

\item{...}{arguments will be passed to \code{\link[=build_query]{build_query()}} function. See \code{?build_query()} for further information.}
}
\value{
a data.frame
}
\description{
This function collects tweets containing strings or hashtags
between specified date ranges filtering by bounding box. Tweet-level data is stored in a data/
path as a series of JSONs beginning "data_"; User-level data is stored as a series of
JSONs beginning "users_". If a filename is supplied, this function will
save the result as a RDS file, otherwise it will return the results as a dataframe.
Note: width and height of the bounding box must be less than 25mi.
}
\examples{
\dontrun{
bearer_token <- "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
tweets <- get_bbox_tweets("happy", bbox= c(-0.222473,51.442453,0.072784,51.568534),
                           "2021-01-01T00:00:00Z", "2021-02-01T10:00:00Z",
                           bearer_token, data_path = "data/")
}
}
\keyword{internal}
