% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{likelihood_dual}
\alias{likelihood_dual}
\title{Calculate likelihood curve of frequency estimates for a dual-alpha or
dual-beta TCR clone}
\usage{
likelihood_dual(est, err, numb_wells, numb_cells, numb_sample)
}
\arguments{
\item{est}{Clonal frequency estimate}

\item{err}{Mean drop error rate}

\item{numb_wells}{A vector with the number of wells with the distinct
sample sizes}

\item{numb_cells}{A vector of the distinct sample sizes, i.e. the number of
cells per well}

\item{numb_sample}{A vector with the number of wells of the sample size of
the same position of \code{numb_cells} that contains both alpha and the
beta chain of the clone (for dual-alpha clones) or both beta and the
alpha chain of the clone (for dual-beta clones)}
}
\value{
A numeric with the negative log likelihood
}
\description{
Calculate likelihood curve of frequency estimates for a dual-alpha or
dual-beta TCR clone
}

