% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_var.R
\name{filter_var}
\alias{filter_var}
\title{Data Filtering}
\usage{
filter_var(
  df,
  key_var,
  y_var,
  missing_rate,
  single_var_rate,
  iv_set,
  char_to_number = TRUE,
  na.omit = TRUE
)
}
\arguments{
\item{df}{A data.frame with independent variables and target variable.}

\item{key_var}{A name of index variable name.}

\item{y_var}{A name of target variable.}

\item{missing_rate}{Data missing rate, variables smaller than this setting will be deleted.}

\item{single_var_rate}{The maximum proportion of a single variable, the variable greater than the setting will be deleted.}

\item{iv_set}{IV value minimum threshold, variable IV value less than the setting will be deleted.}

\item{char_to_number}{Whether to convert character variables to numeric.}

\item{na.omit}{na.omit returns the object with incomplete cases removed.}
}
\value{
A data frame.
}
\description{
Data Filtering
}
\examples{
accepts <- read.csv( system.file( "extdata" , "accepts.csv",package = "autoScorecard" ))
fff1 <- filter_var( df = accepts, key_var = "application_id", y_var = "bad_ind", missing_rate = 0,
single_var_rate = 1, iv_set = 0.02 )
}
