% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_team_alumni.R
\name{mlb_team_alumni}
\alias{mlb_team_alumni}
\title{\strong{MLB Team Alumni}}
\usage{
mlb_team_alumni(team_id = NULL, stat_group = NULL, season = NULL)
}
\arguments{
\item{team_id}{Team ID to return information and ranking for a particular statistic for a particular team.}

\item{stat_group}{Stat group to return information and ranking for a particular statistic in a particular group.}

\item{season}{Year to return information and ranking for a particular statistic in a given year.}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   player_id \tab integer \cr
   player_full_name \tab character \cr
   link \tab character \cr
   first_name \tab character \cr
   last_name \tab character \cr
   primary_number \tab character \cr
   birth_date \tab character \cr
   current_age \tab integer \cr
   birth_city \tab character \cr
   birth_country \tab character \cr
   height \tab character \cr
   weight \tab integer \cr
   active \tab logical \cr
   use_name \tab character \cr
   middle_name \tab character \cr
   boxscore_name \tab character \cr
   nick_name \tab character \cr
   gender \tab character \cr
   name_matrilineal \tab character \cr
   is_player \tab logical \cr
   is_verified \tab logical \cr
   pronunciation \tab character \cr
   mlb_debut_date \tab character \cr
   name_first_last \tab character \cr
   name_slug \tab character \cr
   first_last_name \tab character \cr
   last_first_name \tab character \cr
   last_init_name \tab character \cr
   init_last_name \tab character \cr
   full_fml_name \tab character \cr
   full_lfm_name \tab character \cr
   strike_zone_top \tab numeric \cr
   strike_zone_bottom \tab numeric \cr
   alumni_last_season \tab character \cr
   birth_state_province \tab character \cr
   draft_year \tab integer \cr
   primary_position_code \tab character \cr
   primary_position_name \tab character \cr
   primary_position_type \tab character \cr
   primary_position_abbreviation \tab character \cr
   bat_side_code \tab character \cr
   bat_side_description \tab character \cr
   pitch_hand_code \tab character \cr
   pitch_hand_description \tab character \cr
}
}
\description{
\strong{MLB Team Alumni}
}
\examples{
\donttest{
  try(mlb_team_alumni(team_id = 137, stat_group = 'hitting', season = 2021))
}
}
