% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/29_zShortSyntheticFuturePnL.R
\name{zShortSyntheticFuturePnL}
\alias{zShortSyntheticFuturePnL}
\title{Calculates Profit and Loss at expiration for Short Synthetic Future (per unit of the underlying) and draws its graph in the Plots tab.}
\usage{
zShortSyntheticFuturePnL(
  STF,
  XF,
  COF,
  POF,
  hl = 0,
  hu = 1.6,
  xlab = "Future Contract Price ($) at Expiration of Options on Future",
  ylab = " Profit and Loss [ PnL] ($) at Expiration",
  main = "Short Synthetic Future [ PnL ]"
)
}
\arguments{
\item{STF}{Future contract price at time T.}

\item{XF}{Strike Price of Option on Future.}

\item{COF}{Call Premium received from Option on Future  .}

\item{POF}{Put premium paid on Option on Future.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Title of the Graph.}
}
\value{
Returns a graph of the strategy.
}
\description{
This strategy results from shorting a call of the option on Future and buying a put of the option on the Future of the same strike price with the same expiration. On initiation, this is a net credit Strategy and results in net cash inflow as premium received on shorting a call of the option on Future is more than premium paid on buying a put of the option on Future (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed-form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute Profit and Loss at expiration for Short Synthetic Future (per unit of the underlying) and draw its graph in the Plots tab.
}
\examples{
zShortSyntheticFuturePnL(12,14,4,2)
zShortSyntheticFuturePnL(200,205,7,2,hl=0.95,hu=1.1)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group. https://bookshelf.vitalsource.com/books/9780133964448\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
