% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfsl.R
\name{augment.bfsl}
\alias{augment.bfsl}
\title{Augment Data with Information from a bfsl Object}
\usage{
\method{augment}{bfsl}(x, data = x$data, newdata = NULL, ...)
}
\arguments{
\item{x}{A `bfsl` object created by [bfsl::bfsl()]}

\item{data}{A [base::data.frame()] or [tibble::tibble()] containing all the
original predictors used to create x. Defaults to NULL, indicating that
nothing has been passed to newdata. If newdata is specified, the data argument
will be ignored.}

\item{newdata}{A [base::data.frame()] or [tibble::tibble()] containing all
the original predictors used to create x. Defaults to NULL, indicating that
nothing has been passed to newdata. If newdata is specified, the data
argument will be ignored.}

\item{...}{Unused, included for generic consistency only.}
}
\value{
A [tibble::tibble()] with columns:
\item{.fitted}{Fitted or predicted value.}
\item{.se.fit}{Standard errors of fitted values.}
\item{.resid}{The residuals, that is \code{y} observations minus fitted
values. (Only returned if \code{newdata = NULL}).}
}
\description{
Broom tidier method to \code{augment} data with information from a bfsl object.
}
\examples{
fit = bfsl(pearson_york_data)

augment(fit)

}
