% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binance.R
\name{binance_klines}
\alias{binance_klines}
\title{Get kline/candlestick data from Binance}
\usage{
binance_klines(
  symbol,
  interval = c("1m", "3m", "5m", "15m", "30m", "1h", "2h", "4h", "6h", "8h", "12h",
    "1d", "3d", "1w", "1M"),
  limit,
  start_time,
  end_time
)
}
\arguments{
\item{symbol}{string}

\item{interval}{enum}

\item{limit}{optional int}

\item{start_time}{optional POSIX timestamp}

\item{end_time}{optional POSIX timestamp}
}
\value{
\code{data.table} with open-high-low-close values
}
\description{
Get kline/candlestick data from Binance
}
\examples{
\dontrun{
binance_klines('ETHUSDT')
binance_klines('ETHUSDT', interval = '1h', limit = 24*7)
binance_klines('ETHUSDT', interval = '1h', start_time = '2018-01-01', end_time = '2018-01-08')
}
}
