% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasch.R
\name{rasch}
\alias{rasch}
\title{Rasch Model Calibration}
\usage{
rasch(s, f)
}
\arguments{
\item{s}{a numeric vector representing the column sum for the \code{J} items.}

\item{f}{a numeric vector representing the frequencies for the scores from
1 to \code{J}-1.}
}
\description{
Yields estimates of item difficulty parameters and ability parameters
under the one-parameter logistic Rasch model by the Birnbaum paradigm.
}
\details{
With data editing command lines, the item response data matrix of
\code{N} by \code{J} is to be converted to the two vectors of the column
sum \code{s} and the frequencies for the scores \code{f}.
The two vectors are the input for the Birnbaum paradigm to calibrate
the test.
The function contains two other required functions, \code{stage1} and
\code{stage2}.
After obtaining the item and ability parameter estimates from the Birnbaum
paradigm, bias correction methods are applied to the item parameter
estimates and then to the ability parameter estimates.
The estimates of item difficulty parameters \code{b} are reported in
the console window.
The estimates of ability parameters \code{theta} are not for individual
examinees but for the raw score groups ranged from 1 to \code{J}-1.
The function prints out the mean and the standard deviation of the item
parameter estimates as well as those of the ability parameter estimates.
}
\examples{
rm(list = ls()) # remove the existing objects in workspace
s <- c(13, 8, 8, 5, 10, 7, 7, 6, 7, 3)
f <- c(1, 2,  2, 4, 1, 1, 0, 0, 4)
rasch(s, f)
}
\references{
Baker, F. B., & Kim, S.-H. (2017).
\emph{The basics of item response theory using R.}
New York, NY: Springer.
ISBN-13: 978-3-319-54204-1
}
\keyword{rasch}
