% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_class_03_revenue.R
\docType{class}
\name{revenue,-class}
\alias{revenue,-class}
\alias{revenue}
\alias{revenue-class}
\alias{initialize,revenue-method}
\title{S4 Class revenue}
\usage{
\S4method{initialize}{revenue}(
  .Object,
  type,
  category,
  name,
  per_use,
  missing = c("rep", "interpol", "0"),
  due_month = NA,
  valid_types = "default",
  ...,
  .list = list()
)
}
\arguments{
\item{.Object}{The object to initialize.}

\item{type}{A character string defining the type of transaction as defined by \code{valid_types}.}

\item{category}{A character string, custom category for this transaction.}

\item{name}{A character string, custom name or ID for this transaction.}

\item{per_use}{If given, the numbers provided via \code{...} (or \code{.list}) are
not interpreted as the monetary value, but as number of transactions in that
month, and the actual fiscal value is calculated by multiplying it with the value
given here.}

\item{missing}{One of \code{"rep"}, \code{"interpol"}, or \code{"0"}.
This defines how gaps are filled: If \code{"rep"}, present values are repeated
until the next valid value; if \code{"interpol"}, missing values are interpolated
using \code{approx}; if \code{"0"}, missing values are set to zero.}

\item{due_month}{Character vector to define months where transactions are due. This argument
causes previous amounts to be cumulated and thereby postponed to the given month of a year.
Combined with e.g. \code{.list} this makes it easier to turn monthly amounts into quarterly
ones.}

\item{valid_types}{A character string, the model types defined by
\code{\link[businessPlanR:set_types]{set_types}} to be used for validation.
If \code{"default"}, pre-defined example types are used.}

\item{...}{Numeric values named in \code{YYYY.MM} format,
      defining the transaction amount for a particular month.
The resulting object will automatically cover all months from the earliest to the latest among all given values.}

\item{.list}{An alternative to \code{...} if the values are already present as a list. If both are given,
      their values
will be merged into one list.}
}
\description{
This is a special case of the generic class \code{\link[businessPlanR:transaction-class]{transaction}}.
}
\section{Slots}{

\describe{
\item{\code{type}}{A character string, for valid values see \code{valid_types}.}

\item{\code{category}}{A character string, custom category for this revenue.}

\item{\code{name}}{A character string, custom name or ID for this revenue.}

\item{\code{value}}{Data frame containing all revenues,
      each month in a column named \code{YYYY.MM}.}

\item{\code{valid_types}}{A character string, the model types defined by
\code{\link[businessPlanR:set_types]{set_types}} to be used for validation.}
}}

\section{Constructor function}{

Should you need to manually generate objects of this class, the constructor function 
\code{revenue(...)} can be used instead of
\code{new("revenue", ...)}.
}

\examples{
rev_2019_2021 <- revenue(
   type="Sale",
   category="Merch",
   name="T-Shirts",
   "2019.03"=100,
   "2019.08"=267,
   "2020.03"=344,
   "2020.09"=549,
   "2021.02"=770,
   "2021.07"=1022,
   "2021.10"=1263
)
}
\keyword{classes}
