% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrar-auxiliar.R
\name{.get_command_argument}
\alias{.get_command_argument}
\title{Get an specific argument from the command line}
\usage{
.get_command_argument(
  x,
  argument,
  prefix = "--",
  default = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{x}{The command line arguments, from \code{x = commandArgs()}}

\item{argument}{The name of the argument.}

\item{prefix}{The prefix to any argument of interest, the default is "--"}

\item{default}{Default value to return is argument is missing, default to FALSE.}

\item{verbose}{Boolean, if TRUE, shows a warning when the parameter is not found.}
}
\value{
The value of the argument, assumed to be followed after '=' or, TRUE if nothing but the argument was found. 
If the argument is not found, FALSE is returned.
}
\description{
Get an specific argument from the command line
}
\examples{
.get_command_argument(commandArgs(), "interactive")
.get_command_argument(commandArgs(), "RStudio")
.get_command_argument(commandArgs(), "RStudio", prefix="")
.get_command_argument(commandArgs(), "vanilla")
.get_command_argument("--control.file=baz.txt", "control.file")
}
