% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrar-test_functions.R
\name{sphereN}
\alias{sphereN}
\title{Sphere function with random noise}
\usage{
sphereN(x, sd = 0.1, aggregate = TRUE)
}
\arguments{
\item{x}{The coordinates of the point}

\item{sd}{The standard deviation of the noise
to be added to the position of \code{x}, a normal distribution with mean
zero is used.}

\item{aggregate}{If \code{aggregate} is \code{TRUE} the distance is returned, 
otherwise the size of the projection of the distance among each axis.}
}
\value{
The distance from the point \code{x} to the origin after a random
displacement.
}
\description{
This function calculates the Euclidian distance from a point to the origin
after a random displacement of its position.
}
\examples{
sphereN(rep(0, 10))
}
\author{
Ricardo Oliveros--Ramos
}
\keyword{random}
\keyword{stochastic}
