% Generated by roxygen2 (4.0.2): do not edit by hand
\name{closeness.vitality}
\alias{closeness.vitality}
\title{Find the closeness vitality centrality in a strongly connected graph}
\usage{
closeness.vitality(graph, vids = V(graph), mode = c("all", "out", "in"),
  weights = NULL)
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}

\item{mode}{Character string, defined the types of the paths used for measuring the distance in directed graphs. 'in' measures the paths to a vertex, 'out' measures paths from a vertex, all uses undirected paths. This argument is ignored for undirected graphs.}

\item{weights}{Possibly a numeric vector giving edge weights. If this is NULL, the default, and the graph has a weight edge attribute, then the attribute is used. If this is NA then no weights are used (even if the graph has a weight attribute).}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
Closeness vitality of a node is the change in the sum of distances between all node pairs when excluding that node.
}
\details{
More detail at \href{http://www.centiserver.org/?q1=centrality&q2=Closeness_Vitality}{Closeness Vitality}
}
\examples{
g <- graph(c(1,2,2,3,3,4,4,2,1,4), directed=FALSE)
closeness.vitality(g)
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}
}
\references{
Brandes, U. & Erlebach, T. 2005. Network Analysis: Methodological Foundations, U.S. Government Printing Office.
}

