% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fraction_of_ss.R
\name{fraction_of_ss}
\alias{fraction_of_ss}
\title{Calculate fraction of steady state at particular time after start of dosing}
\usage{
fraction_of_ss(kel = NULL, halflife = NULL, t = NULL, n = NULL, tau = NULL)
}
\arguments{
\item{kel}{drug elimination rate}

\item{halflife}{halflife. Either `kel` or `halflife` is required.}

\item{t}{time at which to calculate fraction of steady state}

\item{n}{number of dosing intervals after which to calculate fraction of steady state. Requires `tau` as well, cannot be used together with `t` argument.}

\item{tau}{dosing interval}
}
\description{
Calculate fraction of steady state at particular time after start of dosing
}
\examples{
fraction_of_ss(halflife = 24, t = 72)
fraction_of_ss(halflife = 36, n = 3, tau = 24)
}
