% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{p_equiv}
\alias{p_equiv}
\title{p-Value for one-sample equivalency}
\usage{
p_equiv(m, t1, t2)
}
\arguments{
\item{m}{the size of the acceptance sample}

\item{t1}{the test statistic described above. May be a vector.}

\item{t2}{the test statistic described above. May be a vector.}
}
\value{
a vector of p-Values of the same length as t1 and t2
}
\description{
Calculates the p-Value for a one-sample acceptance test
based on Vangel (2002).
This test considers the sample size of the acceptance sample (\code{m}).

Two test statistics are required:

t1 = (mu - Y_min) / sigma

t2 = (mu - Y_mean) / sigma

Where:
\itemize{
\item mu is the mean of the population
\item sigma is the standard deviation of the population
\item Y_min is the minimum from the acceptance sample
\item Y_mean is the mean of the acceptance sample
}
}
