% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\encoding{UTF-8}
\name{vech}
\alias{vech}
\alias{vechs}
\alias{cvec}
\alias{rvec}
\title{Vectorize a matrix}
\usage{
vech(x)

vechs(x)

cvec(x)

rvec(x)
}
\arguments{
\item{x}{A matrix}
}
\value{
A vector of values
}
\description{
\code{cvec} returns the column-wise vectorization of an input matrix (stacking
the columns on one another). \code{rvec} returns the row-wise vectorization of an
input matrix (concatenating the rows after each other). \code{vech} returns the
column-wise half-vectorization of an input matrix (stacking the lower
triangular elements of the matrix, including the diagonal). \code{vechs} returns
the strict column-wise half-vectorization of an input matrix (stacking the
lower triangular elements of the matrix, excluding the diagonal). All
functions return the output as a vector.
}
\examples{
cvec(matrix(1:9, 3, 3))
rvec(matrix(1:9, 3, 3))
vech(matrix(1:9, 3, 3))
vechs(matrix(1:9, 3, 3))
vechs(matrix(1:12, 3, 4))
}
\author{
Based on functions from the the \pkg{OpenMx} package
}
