% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onload.R
\name{set_cookie_on_load}
\alias{set_cookie_on_load}
\title{Shiny tag to add cookies on page load}
\usage{
set_cookie_on_load(
  cookie_name,
  cookie_value,
  expiration = 90,
  secure_only = NULL,
  domain = NULL,
  path = NULL,
  same_site = NULL
)
}
\arguments{
\item{cookie_name}{The name of the cookie. Can contain any US-ASCII
characters except for: the control character, space, a tab, or separator
characters like ( ) < > @ , ; : \\ " / [ ] ? = \{ \}.}

\item{cookie_value}{The contents of the cookie as a single character value.}

\item{expiration}{Days after which the cookie should expire. To remove an
HttpOnly cookie, send a negative value for this attribute.}

\item{secure_only}{Logical indicating whether the cookie should only be
accessible via secure (\verb{https:}) requests (except on localhost).}

\item{domain}{The host to which the cookie will be sent (including
subdomains). If this is \code{NULL} (default) the cookie will only be sent to
the host of the page where this cookie was set (not including subdomains).}

\item{path}{The path that must exist in the requested URL for the browser to
send this cookie. Includes subdirectories.}

\item{same_site}{One of "strict", "lax" (default), or "none", indicating when
the cookie should be sent. When \code{same_site = "none"}, \code{secure_only} must be
\code{TRUE}.}
}
\value{
A \code{\link[shiny:reexports]{shiny::tagList()}} that provides the HTML and javascript to set the
cookie.
}
\description{
Generate a \code{\link[shiny:reexports]{shiny::tagList()}} which uses JavaScript to set a cookie in the
user's browser when the shiny app loads.
}
\examples{
set_cookie_on_load("my_cookie", "contents of my cookie")
set_cookie_on_load("my_cookie", "contents of my cookie", expiration = 10)
}
