% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_activity.R
\name{sch_add_activity}
\alias{sch_add_activity}
\title{Add Activity}
\usage{
sch_add_activity(sch, id, name, duration, ..., direction = "succ")
}
\arguments{
\item{sch}{A schedule object.}

\item{id}{Activity id that will be used to make
relation between activities. It must be unique.}

\item{name}{The name of activity.}

\item{duration}{A number that represents the activity's duration.
It must be equal or greater than zero.}

\item{...}{A set of activity id relation such that will be linked with
activity id. It may be relations of successor or predecessors.}

\item{direction}{Direction of relations: It may be "succ" or "pred".
\itemize{
\item \code{succ}: The relations_id will be the successor of the activity.
\item \code{pred}: The relations_id will be the predecessor of the activity.
}}
}
\value{
A Schedule object with an activity added to it.
If relations id is present, it will be included to the schedule.
}
\description{
Add an activity and her relations to a schedule. The relations are optional.
They will be included if a set of activity id is informed,
after activity duration.
}
\examples{
# Example #1: Only with activities
sch <- sch_new() \%>\%
  sch_add_activity(1L, "Task 1", 5L) \%>\%
  sch_add_activity(2L, "Task 2", 6L) \%>\%
  sch_add_activity(3L, "Task 3", 8L) \%>\%
  sch_add_activity(4L, "Task 4", 6L) \%>\%
  sch_add_activity(5L, "Task 5", 9L) \%>\%
  sch_add_activity(6L, "Task 6", 3L) \%>\%
  sch_add_activity(7L, "Task 7", 4L) \%>\%
  sch_plan()
sch_duration(sch)
sch_activities(sch)

# Example #2: With activities and relations.
sch <- sch_new() \%>\%
  sch_add_activity(1L, "Task 1", 5L, 2L, 3L) \%>\%
  sch_add_activity(2L, "Task 2", 6L, 4L) \%>\%
  sch_add_activity(3L, "Task 3", 8L, 5L) \%>\%
  sch_add_activity(4L, "Task 4", 6L, 6L) \%>\%
  sch_add_activity(5L, "Task 5", 9L, 6L) \%>\%
  sch_add_activity(6L, "Task 6", 3L, 7L) \%>\%
  sch_add_activity(7L, "Task 7", 4L) \%>\%
  sch_plan()
sch_duration(sch)
sch_activities(sch)
sch_relations(sch)


}
\seealso{
\code{\link[=sch_change_activities_duration]{sch_change_activities_duration()}}, \code{\link[=sch_has_any_activity]{sch_has_any_activity()}},
\code{\link[=sch_new]{sch_new()}}, \code{\link[=sch_add_activities]{sch_add_activities()}}, \code{\link[=sch_get_activity]{sch_get_activity()}}, \code{\link[=sch_plan]{sch_plan()}},
\code{\link[=sch_nr_activities]{sch_nr_activities()}}, \code{\link[=sch_add_relation]{sch_add_relation()}}.
}
