% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findRFM.R
\name{findRFM}
\alias{findRFM}
\title{Compute RFM for Transaction Data}
\usage{
findRFM(customerdata, recencyWeight = 4, frequencyWeight = 4,
  monetoryWeight = 4)
}
\arguments{
\item{customerdata}{- A data frame of the follwing coloumns - TransactionID, Customer ID, Date of Transaction (in date format),Amount of purchase}

\item{recencyWeight}{- Weight the model should assign to the recency factor}

\item{frequencyWeight}{- Weight the model should assign to the frequency factor}

\item{monetoryWeight}{- Weight the model should assign to the monetory factor}
}
\value{
A data frame summarized ar customer ID level with the folloiwng data :

Individual Recency, Frequency and Monetary Scores for the data set

Weighted individual Recency, Frequency and Monetary scores for the data set

Final RFM and Weighted RFM scores for each customer

Customer class on a 5 point scale
}
\description{
The function calculates the RFM value of a given customer data.The function consumes customer
data in a fixed format and returns RFM values and scores for each customer.
\href{https://github.com/didroo55/didrooPackages/blob/master/didrooRFM.pdf}{Click here for an overview document}
\href{https://youtu.be/SojqDzHpKRA}{Click here for a VIDEO TUTORIAL}
}
\examples{
TransNo <- c('0','1')
CustomerID <- c('Cust1','Cust2')
DateofPurch <- as.Date(c('2010-11-1','2008-3-25'))
Amount <- c(1000,500)
customerData <- data.frame(TransNo,CustomerID,DateofPurch,Amount)
findRFM(customerData)
}
