% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R, R/methods.R
\docType{class}
\name{Counts-class}
\alias{Counts-class}
\alias{get_counts,Counts-method}
\alias{get_fractions,Counts-method}
\alias{set_counts<-,Counts-method}
\alias{set_fractions<-,Counts-method}
\alias{compute_posterior,Counts-method}
\alias{get_posterior_param,Counts-method}
\alias{plot_posterior,Counts-method}
\title{An S4 class to store measurements (count data, sampling fractions),
prior support and posterior parameters}
\usage{
\S4method{get_counts}{Counts}(object)

\S4method{get_fractions}{Counts}(object)

\S4method{set_counts}{Counts}(object) <- value

\S4method{set_fractions}{Counts}(object) <- value

\S4method{compute_posterior}{Counts}(
  object,
  n_start,
  n_end,
  replacement = FALSE,
  b = 1e-10,
  alg = "dup"
)

\S4method{get_posterior_param}{Counts}(object, low = 0.025, up = 0.975, ...)

\S4method{plot_posterior}{Counts}(object, low = 0.025, up = 0.975, xlab, step, ...)
}
\arguments{
\item{object}{object of class \code{Counts}}

\item{value}{numeric vector of sampling fractions}

\item{n_start}{start of prior support range}

\item{n_end}{end of prior support range}

\item{replacement}{was sampling performed with replacement? Default to FALSE}

\item{b}{prior rate parameter of the gamma distribution used to compute the posterior with Clough. Default to 1e-10}

\item{alg}{algorithm to be used to compute posterior. One of ... . Default to "dup"}

\item{low}{1 - right tail posterior probability}

\item{up}{left tail posterior probability}

\item{...}{additional parameters to be passed to \link{curve}}

\item{xlab}{x-axis label. Default to 'n' (no label)}

\item{step}{integer defining the increment for x-axis labels (distance between two consecutive tick marks)}
}
\value{
counts vector from a \code{Counts} object

fractions vector from a \code{Counts} object

an object of class \code{Counts}

an object of class \code{Counts}

an object of class \code{Counts}

an object of class \code{Counts}

no return value, called for side effects
}
\description{
An S4 class to store measurements (count data, sampling fractions),
prior support and posterior parameters
}
\section{Methods (by generic)}{
\itemize{
\item \code{get_counts(Counts)}: Returns counts from a \code{Counts} object

\item \code{get_fractions(Counts)}: Returns fractions from a \code{Counts} object

\item \code{set_counts(Counts) <- value}: Replaces counts of a \code{Counts} object with the provided values

\item \code{set_fractions(Counts) <- value}: Replaces fractions of a \code{Counts} object with the provided values

\item \code{compute_posterior(Counts)}: Compute the posterior probability distribution of the population size

\item \code{get_posterior_param(Counts)}: Extract statistical parameters (e.g. credible intervals) 
from a posterior probability distribution

\item \code{plot_posterior(Counts)}: Plot posterior probability distribution and posterior parameters

}}
\section{Slots}{

\describe{
\item{\code{counts}}{integer vector of counts (required)}

\item{\code{fractions}}{numeric vector of sampling fractions (required)}

\item{\code{n_start}}{start of prior support range. If omitted and total \code{counts} greater than zero,
computed as 0.5 * \code{mle}, where \code{mle} is the maximum likelihood estimate of the population size}

\item{\code{n_end}}{end of prior support range. If omitted and total \code{counts} greater than zero,
computed as 2 * \code{mle}, where \code{mle} is the maximum likelihood estimate of the population size}

\item{\code{f_product}}{product of (1-\code{fractions})}

\item{\code{mle}}{maximum likelihood estimate of the population size (ratio between total counts and total sampling fraction)}

\item{\code{norm_constant}}{normalization constant}

\item{\code{posterior}}{numeric vector of posterior probabilities over the prior support}

\item{\code{map_p}}{maximum of \code{posterior} probability}

\item{\code{map_index}}{index of prior support corresponding to the maximum a posteriori}

\item{\code{map}}{maximum a posteriori of population size}

\item{\code{q_low}}{lower bound of the credible interval}

\item{\code{q_low_p}}{probability of the lower bound of the credible interval}

\item{\code{q_low_index}}{index of the prior support corresponding to \code{q_low}}

\item{\code{q_low_cum_p}}{cumulative posterior probability from \code{n_start} to \code{q_low} (left tail)}

\item{\code{q_up}}{upper bound of the credible interval}

\item{\code{q_up_p}}{probability of the upper bound of the credible interval}

\item{\code{q_up_index}}{index of the prior support corresponding to \code{q_high}}

\item{\code{q_up_cum_p}}{cumulative posterior probability from \code{q_high} to \code{n_end} (right tail)}

\item{\code{gamma}}{logical, TRUE if posterior computed using a Gamma approximation}
}}

\note{
The \code{posterior} slot contains either the PMF or a logical value used to 
compute posterior parameters with a Gamma approximation (see reference for details)

Lower and upper bounds of the credibile interval are computed at a default
confidence level of 95%

For more details on the normalization constant, see Corollary 1 in reference
}
\examples{
# constructor:
# create an object of class 'Counts'
new_counts(counts = c(30, 35), fractions = c(0.075, 0.1))

# same, using new
new("Counts", counts = c(30, 35), fractions = c(0.075, 0.1))

}
\references{
Comoglio F, Fracchia L and Rinaldi M (2013) 
Bayesian inference from count data using discrete uniform priors. 
\href{https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0074388}{PLoS ONE 8(10): e74388}
}
\seealso{
\link{compute_posterior}, \link{get_posterior_param}
}
\author{
Federico Comoglio
}
\keyword{class}
