% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{compute_posterior}
\alias{compute_posterior}
\title{Compute the posterior probability distribution of the population size 
for an object of class \code{Counts}}
\usage{
compute_posterior(
  object,
  n_start,
  n_end,
  replacement = FALSE,
  b = 1e-10,
  alg = "dup"
)
}
\arguments{
\item{object}{object of class \code{Counts}}

\item{n_start}{start of prior support range}

\item{n_end}{end of prior support range}

\item{replacement}{was sampling performed with replacement? Default to FALSE}

\item{b}{prior rate parameter of the gamma distribution used to compute the posterior with Clough. Default to 1e-10}

\item{alg}{algorithm to be used to compute posterior. One of ... . Default to "dup"}
}
\value{
an object of class \code{Counts}
}
\description{
Compute the posterior probability distribution of the population size 
using a discrete uniform prior and a binomial likelihood ("dup" algorithm, Comoglio et al.). 
An approximation using a Gamma prior and a Poisson likelihood is used when 
applicable ("gamma" algorithm) method (see Clough et al. for details)
}
\examples{
counts <- new_counts(counts = c(20,30), fractions = c(0.075, 0.10))

# default parameters ("dup" algorithm, sampling without replacement, default prior support)
posterior <- compute_posterior(counts)

# custom prior support ("dup" algorithm)
posterior <- compute_posterior(counts, n_start = 0, n_end = 1e3)

# gamma prior ("gamma" algorithm)
posterior <- compute_posterior(counts, alg = "gamma")

# sampling with replacement
posterior <- compute_posterior(counts, replacement = TRUE)

}
\references{
Comoglio F, Fracchia L and Rinaldi M (2013) 
Bayesian inference from count data using discrete uniform priors. 
\href{https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0074388}{PLoS ONE 8(10): e74388}

Clough HE et al. (2005) 
Quantifying Uncertainty Associated with Microbial Count Data: A Bayesian Approach. 
\href{https://onlinelibrary.wiley.com/doi/abs/10.1111/j.1541-0420.2005.030903.x}{Biometrics 61: 610-616}
}
\author{
Federico Comoglio
}
