% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equil2.R
\name{equil2}
\alias{equil2}
\title{Calculate urine saturation with the EQUIL-2 algorithm}
\usage{
equil2(
  sodium_mEq_L,
  potassium_mEq_L,
  calcium_mg_dL,
  magnesium_mg_dL,
  ammonia_mEq_L,
  chloride_mEq_L,
  phosphate_mg_dL,
  sulfate_mg_dL,
  oxalate_mg_dL,
  citrate_mg_dL,
  pH,
  urate_mg_dL
)
}
\arguments{
\item{sodium_mEq_L, potassium_mEq_L, ammonia_mEq_L, chloride_mEq_L}{Concentration of the given species in mEq/L (or a unit value that can be
converted to mEq/L)}

\item{calcium_mg_dL, magnesium_mg_dL, phosphate_mg_dL, sulfate_mg_dL, oxalate_mg_dL, citrate_mg_dL, urate_mg_dL}{Concentration of the given species in mg/dL (or a unit value that can be
converted to mg/dL)}

\item{pH}{The urine pH}
}
\value{
A data.frame with three columns:
\itemize{
\item{"species" indicating the chemical species}
\item{"super_saturation" is the supersaturation ratio.  This is SS as
defined in Werness 1985.}
\item{"neg_delta_Gibbs" which is the negative of the change in Gibbs free
energy of transfer from a supersaturated to a saturated solution (the value
is negative for under-saturated solutions, zero for solutions at the
solubility product, and positive for supersaturated solutions).  This is DG
as defined in Werness 1985.}
}
}
\description{
Calculate urine saturation with the EQUIL-2 algorithm
}
\details{
This program is intended for research use, only.  The code within is
translated from Visual Basic code based on Werness, et al 1985 to R.  The
Visual Basic code was kindly provided by Dr. John Lieske of the Mayo
Clinic.
}
\examples{
# Example values from https://files.labcorp.com/testmenu-d8/sample_reports/306266.pdf
equil2(
  sodium_mEq_L=units::set_units(45, "mmol_sodium/L"),
  potassium_mEq_L=units::set_units(55, "mmol_potassium/L"),
  calcium_mg_dL=units::set_units(15, "mg_calcium/dL"),
  magnesium_mg_dL=units::set_units(15, "mg_magnesium/dL"),
  ammonia_mEq_L=units::set_units(10, "ug_ammonia/dL"),
  chloride_mEq_L=units::set_units(75, "mmol_chloride/L"),
  phosphate_mg_dL=units::set_units(100, "mg_phosphate/dL"),
  sulfate_mg_dL=units::set_units(20, "mEq_sulfate/L"),
  oxalate_mg_dL=units::set_units(10, "mg_oxalate/L"),
  citrate_mg_dL=units::set_units(400, "mg_citrate/L"),
  pH=5.5,
  urate_mg_dL=units::set_units(50, "mg_urate/dL")
)

}
\references{
Werness PG, Brown CM, Smith LH, Finlayson B. Equil2: A Basic Computer Program
for the Calculation of Urinary Saturation. Journal of Urology.
1985;134(6):1242-1244. doi:10.1016/S0022-5347(17)47703-2
}
