% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esPlausible.R
\name{esPlausible}
\alias{esPlausible}
\title{esPlausible}
\usage{
esPlausible(dfList, itemVecList)
}
\arguments{
\item{dfList}{a list. Each element of the list must be a data.frame. Each data.frame is a separate raw ESM dataset/an ESM questionnaire version. If there is just one ESM version the list therefore contains one data.frame.}

\item{itemVecList}{a list. Each list element must be a vector. Each vector element must contain all the variable names of the respective ESM questionnaire version. Use function \code{\link{esItems}} to generate \code{itemVecList}.}
}
\value{
A list of dataframes, each containing separate information regarding the plausibility of the ESM datasets. See \strong{Details} for more information.
}
\description{
esPlausible helps detecting implausibilities in the raw ESM datasets.
}
\details{
\code{esPlausible} makes no sense if there is only one ESM questionnaire version. However, if there is more than one version it makes sense. The list which is returned by \code{esPlausible} contains 4 elements:
\enumerate{
\item PlausibNames shows which item names occur in the different ESM questionnaire versions
\item plausibClass shows the class of each item in each of the different ESM questionnaire versions (R built-in class registration)
\item plausibRowNa shows the number of rows in each of the different ESM questionnaire versions and the percentage of existing data therein
\item plausibMinMax shows the minimum and the maximum value for all items containing numeric data.
}
}
\examples{
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
# Prerequisites in order to execute esPlausible. Start --------------
# Use example list delivered with the package
RELEVANTVN_ES <- RELEVANTVN_ESext
# keyLsNew is a list of datasets, also delivered with the package
rmInvLs <- rmInvalid(keyLsNew, RELEVANTVN_ES)
plausibItems <- esItems(dfList=rmInvLs[["dfValid"]], RELEVANTVN_ES)
# Prerequisites in order to execute esPlausible. End ----------------
# -------------------------------------------------------
# Run function 12 of 29; see esmprep functions' hierarchy.
# -------------------------------------------------------
# Help checking the plausibility of items in the raw ESM datasets. rmInvLs[["dfValid"]]
# is one of the results from function 'rmInvalid'.
# plausibItems is the result of function 'esItems'.
plausibLs <- esPlausible(dfList=rmInvLs[["dfValid"]], itemVecList=plausibItems)
# Display the results (4 data frames) to the console
# plausibNames gives an overview of the item names across all ESM versions
plausibLs[["plausibNames"]]
# plausibClass gives an overview of the variable types of all items
plausibLs[["plausibClass"]]
# plausibRowNa shows for each ESM version the number of lines in the raw
# ESM datasets and how much percent of the data is missing (NAs).
plausibLs[["plausibRowNa"]]
# plausibMinMax shows for each numeric variable the minimum and maximum.
plausibLs[["plausibMinMax"]]
# o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o=o
}
\seealso{
Exemplary code (fully executable) in the documentation of \code{\link{esmprep}} (function 12 of 29).
}
