% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_models.R
\name{simulation_model2}
\alias{simulation_model2}
\title{Convenience function for generating functional data}
\usage{
simulation_model2(
  n = 100,
  p = 50,
  outlier_rate = 0.05,
  mu = 4,
  q = 8,
  kprob = 0.5,
  a = 0.1,
  b = 0.9,
  l = 0.05,
  cov_alpha = 1,
  cov_beta = 1,
  cov_nu = 1,
  deterministic = TRUE,
  seed = NULL,
  plot = F,
  plot_title = "Simulation Model 2",
  title_cex = 1.5,
  show_legend = T,
  ylabel = "",
  xlabel = "gridpoints"
)
}
\arguments{
\item{n}{The number of curves to generate. Set to \eqn{100} by default.}

\item{p}{The number of evaluation points of the curves. Curves are usually generated
over the interval \eqn{[0, 1]}. Set to \eqn{50} by default.}

\item{outlier_rate}{A value between \eqn{[0, 1]} indicating the percentage of outliers.
A value of \eqn{0.06} indicates about \eqn{6\%} of the observations will be outliers
depending on whether the parameter \code{deterministic} is \code{TRUE} or not.
Set to \eqn{0.05} by default.}

\item{mu}{The mean value of the functions. Set to \code{4} by default.}

\item{q}{A value indicating the shift of the outliers from the mean function.
Used to control how far the outliers are from the mean function. Set to \code{8} by default.}

\item{kprob}{A value between \eqn{0} and \eqn{1} indicating the probability that an outlier will
be above or below the mean function. Can be used to control the amount of outliers above
or below the mean. Set to \eqn{0.5} by default.}

\item{a, b}{values values specifying the interval \eqn{[a,b]} for the uniform distribution
from which \eqn{T_i} is drawn in the contamination model.}

\item{l}{the value of \eqn{l} in the contamination model}

\item{cov_alpha}{A value indicating the coefficient of the exponential function
of the covariance matrix, i.e., the \eqn{\alpha} in the covariance function.
 Set to \eqn{1} by default.}

\item{cov_beta}{A value indicating the coefficient of the terms inside the exponential
function of the covariance matrix, i.e., the \eqn{\beta} in the covariance function.
Set to \eqn{1} by default.}

\item{cov_nu}{A value indicating the power to which to raise the terms inside the exponential
function of the covariance matrix, i.e., the \eqn{\nu} in the covariance function.
Set to \eqn{1} by default.}

\item{deterministic}{A logical value. If \code{TRUE}, the function will always return
\code{round(n*outlier_rate)} outliers and consequently the number of outliers is always constant.
If \code{FALSE}, the number of outliers are determined using \code{n} Bernoulli trials with
probability \code{outlier_rate}, and consequently the number of outliers returned is random.
\code{TRUE} by default.}

\item{seed}{A seed to set for reproducibility. \code{NULL} by default in which case a seed
is not set.}

\item{plot}{A logical value indicating whether to plot data.}

\item{plot_title}{Title of plot if \code{plot} is \code{TRUE}}

\item{title_cex}{Numerical value indicating the size of the plot title relative to the device default.
Set to 1.5 by default. Ignored if \code{plot = FALSE}.}

\item{show_legend}{A logical indicating whether to add legend to plot if \code{plot = TRUE}.}

\item{ylabel}{The label of the y-axis. Set to \code{""} by default.}

\item{xlabel}{The label of the x-axis if \code{plot = TRUE}. Set to
\code{"gridpoints"} by default.}
}
\value{
A list containing:
\item{data}{a matrix of size \code{n} by \code{p} containing the simulated data set}
\item{true_outliers}{a vector of integers indicating the row index of the outliers in the
generated data.}
}
\description{
This model generates non-persistent magnitude outliers, i.e., the outliers are
magnitude outliers for only a portion of the domain of the functional data. The
main model is of the form: \deqn{X_i(t) = \mu t + e_i(t),} with
contamination model of the form:
\deqn{X_i(t) = \mu t + qk_iI_{T_i \le t\le T_i+l } + e_i(t)}
where: \eqn{t\in [0,1]}, \eqn{e_i(t)} is a Gaussian process with zero mean and
covariance function of the form: \deqn{\gamma(s,t) = \alpha\exp(-\beta|t-s|^\nu),}
\eqn{k_i \in \{-1, 1\}} with \eqn{P(k_i = -1) = P(k_i=1) = 0.5},
\eqn{q} is a constant controlling how far the outliers are from the mass of the
data, \eqn{I} is an indicator function, \eqn{T_i} is a uniform random variable between
an interval \eqn{[a, b] \subset [0,1]}, and \eqn{l} is a constant specifying for how
much of the domain the outliers are away from the mean function.
Please see the simulation models vignette with
 \code{vignette("simulation_models", package = "fdaoutlier")} for more details.
}
\examples{
dtt <- simulation_model2(plot = TRUE)
dtt$true_outliers
dim(dtt$data)
}
